/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DomainParameters;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class DHParams
extends DomainParameters {
    protected ByteArrayAttribute prime_;
    protected ByteArrayAttribute base_;
    protected LongAttribute primeBits_;

    public DHParams() {
        this.keyType_.setLongValue(Key.KeyType.DH);
    }

    protected DHParams(Session session, long l) throws TokenException {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.DH);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.prime_ = new ByteArrayAttribute(Attribute.PRIME);
        this.base_ = new ByteArrayAttribute(Attribute.BASE);
        this.primeBits_ = new LongAttribute(Attribute.PRIME_BITS);
        DHParams.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        DHParams dHParams = (DHParams)super.clone();
        dHParams.prime_ = (ByteArrayAttribute)this.prime_.clone();
        dHParams.base_ = (ByteArrayAttribute)this.base_.clone();
        dHParams.primeBits_ = (LongAttribute)this.primeBits_.clone();
        DHParams.putAttributesInTable(dHParams);
        return dHParams;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof DHParams) {
            DHParams dHParams = (DHParams)object;
            bl = this == dHParams || super.equals(dHParams) && this.prime_.equals(dHParams.prime_) && this.base_.equals(dHParams.base_) && this.primeBits_.equals(dHParams.primeBits_);
        }
        return bl;
    }

    public ByteArrayAttribute getBase() {
        return this.base_;
    }

    public static Object getInstance(Session session, long l) throws TokenException {
        return new DHParams(session, l);
    }

    public ByteArrayAttribute getPrime() {
        return this.prime_;
    }

    public LongAttribute getPrimeBits() {
        return this.primeBits_;
    }

    protected static void putAttributesInTable(DHParams dHParams) {
        if (dHParams == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        dHParams.attributeTable_.put(Attribute.PRIME, dHParams.prime_);
        dHParams.attributeTable_.put(Attribute.BASE, dHParams.base_);
        dHParams.attributeTable_.put(Attribute.PRIME_BITS, dHParams.primeBits_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.prime_);
        Object.getAttributeValue(session, this.objectHandle_, this.base_);
        Object.getAttributeValue(session, this.objectHandle_, this.primeBits_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Prime (hex): ");
        stringBuffer.append(this.prime_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Base (hex): ");
        stringBuffer.append(this.base_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Prime Bits (dec): ");
        stringBuffer.append(this.primeBits_.toString(10));
        return stringBuffer.toString();
    }
}

